<?php
/*
Plugin Name: adivaha&reg; Premium Plugin
Plugin URI: http://www.adivaha.com
Description: GDS &amp; OTA go-LIVE Solution - Amadeus, Travelport (Galileo), Hotelbeds, TBO, Rezlive, Restel and 150+ integrated suppliers. Plug &amp; Play! Have no APIs? No worries, use adivaha&reg; integrated affiliates and GDS bookings APIs and update as you grow!
Author: adivaha&reg; - Travel Tech Company
Version: 3.1
Author URI: http://www.adivaha.com
*/
// define( 'WP_DEBUG', true );
// define( 'WP_DEBUG_LOG', true );
// define( 'WP_DEBUG_DISPLAY', false );

define('ADIVAHA__PLUGIN_DIR', plugin_dir_path(__FILE__));
$site_url = get_site_url();
define('ADIVAHA__PLUGIN_SITE_URL', $site_url); // mine
define('ADIVAHA__PLUGIN_URL', $site_url . "/wp-content/plugins/adivaha/"); // mine
define('DEFAULT_SETTING_URL', 'http://www.abengines.com/wp-content/themes/plugin-main.txt');

$action_url = getActionUrl();

global $current_user, $user_pid, $user_secret_key, $plugin_version, $action_url, $user_email;
$plugin_version = ($plugin_version ? $plugin_version : "v2");

require(ABSPATH . WPINC . '/pluggable.php');

if (!function_exists('wp_get_current_user')) {
    echo 'Function not set';
    function wp_get_current_user()
    {
        global $current_user;
        get_currentuserinfo();
        return $current_user;
    }
}
$current_user = wp_get_current_user();
$user_id = $current_user->ID;
$user_email = $current_user->user_email;

if (!function_exists('get_pid') && !function_exists('get_secret_key') && !function_exists('get_plugin_version')) {
    function get_pid()
    {
        global $user_pid;
        $get_user_pid = get_option('adh_pid', false);
        return $get_user_pid;
    }

    function get_secret_key()
    {
        global $user_secret_key;
        $get_user_secret_key = get_option('adh_secret_key', false);
        return $get_user_secret_key;
    }
}

$user_pid = get_pid($user_id);
$user_secret_key = get_secret_key($user_id);

// Add Toolbar Menus
if (!function_exists('adi_add_admin_bar_link_adi')) {
    function adi_add_admin_bar_link_adi()
    {
        global $wp_admin_bar;
        if (!is_super_admin() || !is_admin_bar_showing())
            return;
        $wp_admin_bar->add_menu(array(
            'id' => 'unq_adivaha',
            'title' => __('adivaha&reg; Plugin', 'adi_framework'),
            'href' => admin_url('admin.php?page=unq_adivaha'),
            'meta'   => array(
                'class'    => 'adi-item2',
            ),
        ));
    }
}
add_action('admin_bar_menu', 'adi_add_admin_bar_link_adi', 26);

add_action('admin_menu', 'adivaha_main_menu');
function adivaha_main_menu()
{
    ob_start();
    global $wpdb;
    global $files;
    global $Plugin_Path;
    $parent_slug = "unq_adivaha";
    add_menu_page("adivaha&reg; Plugin", "adivaha&reg; Plugin", 'manage_options', $parent_slug, "adivaha_dashboard_output", ADIVAHA__PLUGIN_URL . "asset/images/icon.png");
    function adivaha_dashboard_output()
    {
        include(ADIVAHA__PLUGIN_DIR . 'apps/index.php');
    }
}

add_shortcode('adivaha_searchBox', 'searchBox');
add_shortcode('adivaha_searchResults', 'searchResults');
function adivaha_booking_engine()
{
    function searchBox()
    {
        ob_start();
        global $user_pid, $plugin_version;

        if (!isset($user_pid) || (isset($user_pid) && $user_pid == "")) {
            beforeConnect();
        } else {
            echo '<div id="adivaha-wrapper"><script charset="utf-8" type="text/javascript" src="//www.abengines.com/ui/' . $plugin_version . '/' . $user_pid . '/combo/"></script></div>';
        }

        return ob_get_clean();
    }

    function searchResults()
    {
        ob_start();
        global $user_pid, $plugin_version;
        $mid = $_REQUEST['mid'];
        echo "<div id='adivaha-wrapper'><script charset='utf-8' type='text/javascript' src='https://www.abengines.com/ui/" . $plugin_version . "/" . $user_pid . "/" . $mid . "/mt/search-results/'></script></div>";
        return ob_get_clean();
    }
}

function beforeConnect()
{
    echo "<div class='setupguide'><div class='setup-dialog'><div class='setup-content'><div class='setup-body'><p class='setup-bodyimg'><img src='https://www.adivaha.com/images/error.png'/></p><p class='setup-body1'>Config Error: Missing Partner ID (PID) and API Key</p><p class='setup-body2'>Please Configure your Partner ID and API Keys in</p><p class='setup-body3'>WP-Admin &#10132; adivaha &#10132; General Settings</p></div><div class='setup-footer'> <a class='setupbtn setupbtn-default' href='https://www.adivaha.com/documentations/price-comparison/setup-plugin.html' target='_blank'>Setup Documentation</a><a class='setupbtn setupbtn-defaults' href='https://youtu.be/eJEFy7yLd'g'  target='_blank'>Video Guide</a></div></div></div></div><style>.setupguide{left:0;right:0;width:100%;height:100%;margin:0 auto;font-family:sans-serif}.setup-dialog{display:flex;align-items:center;flex-direction:column;height:100%;width:100%;justify-content:center}.setup-content{padding:40px;    padding: 40px;
    background: #fff;
    box-shadow: 0px 1px 7px #6b6a6a2e;}.setup-bodyimg{text-align:center}.setup-body1{    font-size: 19px;
    color: #000;
    font-weight: 700;
    margin-top: 0;}.setup-body2,.setup-body3{font-size: 14px;
    color: #757272;
    font-weight: 500;
    text-align: center;}.setup-body2{margin-bottom:0}.setup-body3{    margin-top: 4px;
    color: #F44336;
    font-weight: 600;}.setup-footer{margin: 20px 0 0;
    float: left;
    width: 100%;
    display: flex;
    align-items: center;
    flex-direction: row;
    justify-content: center;}.setupbtn-default{    border: 2px solid #F44336;
    padding: 10px;
    color: #fff!important;
    font-size: 14px;
    border-radius: 3px;
    font-weight: 500;
    margin-right: 5px;
    cursor: pointer;
    text-decoration: none;
    width: 100%;
    float: left;
    text-align: center;
    background: #F44336;
    text-transform: uppercase}.setupbtn-defaults{ border: 2px solid #F44336;
    padding: 10px;
    color: #F44336!important;
    font-size: 14px;
    border-radius: 3px;
    font-weight: 500;
    margin-right: 5px;
    cursor: pointer;
    text-decoration: none;
    width: 100%;
    float: left;
    text-align: center;
    background: #fff;
    text-transform: uppercase;}</style>";
}

register_activation_hook(__FILE__, 'adivha_pro_install_portal');

add_action('init', 'adivaha_booking_engine');
function adivha_pro_install_portal()
{
    init_db_myplugin();

    // global $user_email;
    // $site_url = get_site_url();
    // updateAdminEmail(array("site_url" => $site_url, "user_email" => $user_email));
}

// Initialize DB Tables
function init_db_myplugin()
{
    // WP Globals
    global $table_prefix, $wpdb, $user_email;
    // Customer Table
    $customerTable = $table_prefix . 'custom_plugin';
    // Create Customer Table if not exist
    if ($wpdb->get_var("show tables like '$customerTable'") != $customerTable) {

        // Query - Create Table
        $sql = "CREATE TABLE `$customerTable` (";
        $sql .= " `id` int(11) NOT NULL auto_increment, ";
        $sql .= " `pid` varchar(25) NOT NULL, ";
        $sql .= " PRIMARY KEY (`id`) ";
        $sql .= ") ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";

        // Include Upgrade Script
        require_once(ABSPATH . '/wp-admin/includes/upgrade.php');
        // Create Table
        dbDelta($sql);
    }
}
function create_page($title_of_the_page, $content, $parent_id = NULL)
{
    global $site_url;

    $array_of_objects = get_posts([
        'title' => $title_of_the_page,
        'post_type' => 'any',
    ]);
    if (count($array_of_objects) == 0) {
        $post_data = array(
            'comment_status' => 'close',
            'ping_status'    => 'close',
            'post_title'    => ucwords($title_of_the_page),
            'post_content'  => $content,
            'post_status'   => 'publish',
            'post_type'      => 'page',
            'post_author'   => 1, // Author ID
            'post_name'      => strtolower(str_replace(' ', '-', trim($title_of_the_page))),
            'page_template' => $title_of_the_page
        );
        $page_id = wp_insert_post($post_data, false);
    }

    $array_of_objects = get_posts([
        'title' => $title_of_the_page,
        'post_type' => 'any',
    ]);

    $page_id = $array_of_objects[0];
    $page_url = $site_url . "/" . $array_of_objects[0]->post_name . "/";

    return $page_url;
}

function getActionUrl()
{
    $url = DEFAULT_SETTING_URL;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLINFO_HEADER_OUT, true);
    curl_setopt($ch, CURLOPT_POST, true);
    $result = curl_exec($ch);
    curl_close($ch);
    return "http://www.abengines.com/wp-content/themes/" . $result;
}

function verifyUser($pid, $secret_key)
{
    global $action_url;
    $data = array('pid' => $pid, 'secret_key' => $secret_key);
    $url = $action_url . "?action=verifyUser";
    $send = json_encode($data);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLINFO_HEADER_OUT, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $send);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

function getDetails()
{
    global $action_url, $user_pid, $user_secret_key;
    $data = array('pid' => $user_pid, 'secret_key' => $user_secret_key);
    $url = $action_url . "?action=getDetails";
    $send = json_encode($data);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLINFO_HEADER_OUT, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $send);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

function addSearchBox()
{
    echo do_shortcode('[adivaha_searchBox]');
}

if ($user_pid && $user_secret_key) {
    $getDetails = getDetails($user_pid, $user_secret_key);
    // echo $getDetails; die();
    $getDetailsResp = json_decode($getDetails, true);
    $plugin_version = $getDetailsResp["searchBoxVersion"];
    $website = $getDetailsResp["website"];
    $siteLogo = $getDetailsResp["siteLogo"];
    $searchResultUrl = $getDetailsResp["searchResultUrl"];
    $smtpsetting_inbuild = $getDetailsResp["smtpsetting_inbuild"];
    $smtpsetting_email = $getDetailsResp["smtpsetting_email"];
    $smtpsetting_password = $getDetailsResp["smtpsetting_password"];
    $smtpsetting_host = $getDetailsResp["smtpsetting_host"];
    $smtpsetting_port = $getDetailsResp["smtpsetting_port"];
    $smtpsetting_ssl = $getDetailsResp["smtpsetting_ssl"];

    if ($getDetailsResp["chatbot"] == "Yes") {
        add_action('wp_footer', 'addSearchBox');
    }
}

function searchResultsUrlUpdate($data)
{
    global $action_url;
    $url = $action_url . "?action=searchResultsUrlUpdate";
    $send = json_encode($data);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLINFO_HEADER_OUT, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $send);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

/* if ($user_secret_key != "") {
    $content = getDetails($user_secret_key);
    $details = json_decode($content);
    if ($details->customer->product_category == "chatbot") {
        add_action('wp_footer', 'addSearchBox');
    }
    $twc_content = json_decode($details->twc->content);
    foreach ($twc_content->common as $key => $value) {
        if ($key == 'combined_search_box_version') {
            $plugin_version = $value;
        }
    }
} */

function updateSetting($data)
{
    global $action_url;
    $url = $action_url . "?action=updateSetting";
    $send = json_encode($data);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLINFO_HEADER_OUT, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $send);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

function smtpSetup($data)
{
    global $action_url;
    $url = $action_url . "?action=smtpSetup";
    $send = json_encode($data);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLINFO_HEADER_OUT, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $send);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

// $getDetailsResp = getDetails($site_url);
// if ($getDetailsResp) $user_email = $getDetailsResp;

if (is_admin()) {
    add_action('wp_ajax_addUser', 'addUser');
    add_action('wp_ajax_nopriv_addUser', 'addUser');
    function addUser()
    {
        $user_pid = $_REQUEST['pid'];
        $user_secret_key = $_REQUEST['secret_key'];

        $flag = 0;
        if ($user_pid != "" && $user_secret_key != "") {
            $verify = verifyUser($user_pid, $user_secret_key);

            if ($verify) {
                $respOne = add_option('adh_pid', $user_pid, 'yes');
                $respTwo = add_option('adh_secret_key', $user_secret_key, 'yes');

                $page_url = create_page('adivaha Search Results', '[adivaha_searchResults]');
                searchResultsUrlUpdate(array("pid" => $user_pid, "page_url" => urlencode($page_url)));

                if ($respOne && $respTwo) $flag = 1;
                else $flag = 0;
            } else {
                $flag = 0;
            }
        }
        echo $flag;
        die();
    }

    add_action('wp_ajax_deleteUser', 'deleteUser');
    add_action('wp_ajax_nopriv_deleteUser', 'deleteUser');
    function deleteUser()
    {
        global $user_pid, $user_secret_key;

        $flag = 0;
        if ($user_pid && $user_secret_key) {
            $respOne = delete_option('adh_pid');
            $respTwo = delete_option('adh_secret_key');

            if ($respOne && $respTwo) $flag = 1;
            else $flag = 0;
        }
        echo $flag;
        die();
    }

    add_action('wp_ajax_update_setting', 'update_setting');
    add_action('wp_ajax_nopriv_update_setting', 'update_setting');
    function update_setting()
    {
        global $user_pid, $user_secret_key;
        $flag = 0;

        $_REQUEST["pid"] = $user_pid;
        $_REQUEST["secret_key"] = $user_secret_key;

        $resp = updateSetting($_REQUEST);
        if ($resp) $flag = 1;
        else $flag = 0;

        echo $flag;
        die;
    }

    add_action('wp_ajax_smtp_setup', 'smtp_setup');
    add_action('wp_ajax_nopriv_smtp_setup', 'smtp_setup');
    function smtp_setup()
    {
        global $user_pid, $user_secret_key;
        $flag = 0;

        $_REQUEST["pid"] = $user_pid;
        $_REQUEST["secret_key"] = $user_secret_key;

        $resp = smtpSetup($_REQUEST);
        if ($resp) $flag = 1;
        else $flag = 0;

        echo $flag;
        die;
    }

    /* add_action('wp_ajax_update_setting', 'update_setting');
    add_action('wp_ajax_nopriv_update_setting', 'update_setting');
    function update_setting()
    {
        global $wpdb, $user_pid, $user_secret_key, $user_id;

        $flag = 0;

        $customer_banner_image_one = $_REQUEST['customer_banner_image_one'];
        $customer_banner_image_two = $_REQUEST['customer_banner_image_two'];
        $customer_banner_image_array = array();

        $content = getDetails($user_secret_key);
        $details = json_decode($content);
        $theme_content = json_decode($details->customer->theme_content);
        foreach ($theme_content->step1 as $key => $value) {
            if ($key == 'banner_path1') {
                $customer_banner_image_array[$key] = $customer_banner_image_one;
            } elseif ($key == 'banner_path2') {
                $customer_banner_image_array[$key] = $customer_banner_image_two;
            } else {
                $customer_banner_image_array[$key] = $value;
            }
        }
        $step1 = array("step1" => $customer_banner_image_array);
        $theme_content_update = json_decode(json_encode($step1));
        $_REQUEST['theme_content'] = $theme_content_update;

        $restData_update = array();
        $twc_content = json_decode($details->twc->content);
        $search_result_modules = json_decode(json_encode($details->search_result_modules), true);
        if ($twc_content->restData != "") {
            foreach ($twc_content->restData as $key => $value) {
                if (count(explode("result", $key)) > 1) {
                    $restData_update[$key] = $_REQUEST['search_result_url'];
                } else {
                    $restData_update[$key] = $value;
                }
            }
        }

        $twc_content = array("common" => $twc_content->common, "restData" => $restData_update);
        $content = json_decode(json_encode($twc_content));
        $_REQUEST['content'] = $content;

        $updated = settingUpdate($_REQUEST);
        if ($updated) {
            $flag = 1;
        } else {
            $flag = 0;
        }
        echo $flag;
        die;
    } */
}
